function spawnEnemy(%val)
{
	if(!%val)
		return;
	
	if(worldEnemyGroup.getCount() > $worldEnemyMax)
		return;
	
	%posX = $Player.getPositionX() / 4;
	%posY = $Player.getPositionY() / 4;
	%pPosX = mRound(%posX) * 4;
	%pPosY = mRound(%posY) * 4;
	//%pos = %posX @ ".000000 " @ %posY @ ".000000";
	
	%posX = %pPosX + getRandom(-21, 21);
	%posY = %pPosY + getRandom(-21, 21);
	%pos = %posX @ ".000000 " @ %posY @ ".000000";
	
	while(!isValidSpawnPos(%pos))
	{
		%posX = %pPosX + (getRandom(-21, 21) * 4);
		%posY = %pPosY + (getRandom(-21, 21) * 4);
		%pos = %posX @ ".000000 " @ %posY @ ".000000";
	}
	
	%obj = new t2dStaticSprite()
	{
		scenegraph = $Player.scenegraph;
		size = "3.5 3.5";
		position = %pos;
		imageMap = powerHitIndicatorImageMap;
		layer = 1;
		class = "worldEnemy";
	};
	%obj.setCollisionActive(1, 1);
	%obj.setCollisionResponse("CLAMP");
	%obj.setCollisionMasks(BIT(2) | BIT(0), BIT(2) | BIT(0));
	%obj.setCollisionCallback(1);
	
	worldEnemyGroup.add(%obj);
}

if(!isObject(worldEnemyGroup))
{
	new simGroup(worldEnemyGroup);
}

function isValidSpawnPos(%pos)
{
	if(t2dVectorDistance(%pos, $Player.getPosition()) < 60)
		return(0);
	
	%obj = $Player.scenegraph.pickPoint(getWord(%pos, 0), getWord(%pos, 1), 1, -1, 1, $Player);
	if(%obj !$= "")
		return(1);
	
	return(0);
}

function enemyLogicLoop()
{
	if(isEventPending($enemyLogicLoop))
		cancel($enemyLogicLoop);
	$enemyLogicLoop = schedule(100, 0, enemyLogicLoop);
	
	if($battleInProgress || $justLeftBattle)
		return;
	
	for(%i = 0; %i < worldEnemyGroup.getCount(); %i++)
	{
		%obj = worldEnemyGroup.getObject(%i);
		if(t2dVectorDistance(%obj.getPosition(), $Player.getPosition()) > 90)
		{
			removeEnemy(%obj, 1);
		}else{
			if(t2dVectorDistance(%obj.getPosition(), $Player.getPosition()) < 36 && $Player.scenegraph.pickLine(%obj.getPositionX(), %obj.getPositionY(), $Player.getPositionX(), $Player.getPositionY(), BIT(2), -1, 0, %obj) == $Player)
				%obj.moveTo($Player.getPosition(), 24, 1, 0, 1, 0.1);
		}
	}
}

function removeEnemy(%obj, %remake)
{
	%obj.safeDelete();
	
	if(%remake)
	{
		schedule(getRandom(500, 1000), 0, "spawnEnemy", 1);
	}
}

enemyLogicLoop();

function worldEnemy::onCollision(%obj, %col)
{
	if(%col != $Player.getId() || $justLeftBattle || $battleInProgress)
		return;
	
	%obj.moveTo(%obj.getPosition(), 1);
	%obj.setCollisionCallback(0);
	%obj.schedule(500, safeDelete);
	practiceBattle(1);
}